<?php
/**
 * @package Linen
 */

global $linen; ?>
<div id="featured" class="clear">
	<div class="container">
		<div id="slides">
			<div class="slides_container">
				<?php
					$featured_query = new WP_Query( array(
						'post__in' => get_option( 'sticky_posts' ),
						'posts_per_page' => 999
					) );
				?>
				<?php $slider_counter = 1; ?>
				<?php if ( $featured_query->have_posts() ) : ?>
					<?php while ( $featured_query->have_posts() ) : $featured_query->the_post(); ?>
						<div id="slide-<?php echo esc_attr( $slider_counter ); ?>" class="slide<?php echo ( ! $linen->use_javascript_slider() || $slider_counter == 1 ) ? ' show-slide' : ''; ?>">
							<?php if ( has_post_thumbnail() ) :
								the_post_thumbnail( 'featured', array( 'class' => 'feature-photo' ) );
							endif; ?>
							<div class="slide-content">
								<h2><a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php esc_attr( sprintf( __( 'Permanent Link to %s', 'linen' ), the_title_attribute( 'echo=false' ) ) ); ?>"><?php the_title(); ?></a></h2>
								<?php
									if ( $post->post_excerpt ) {
										echo $linen->custom_excerpt();
									} else {
										echo $linen->custom_content( 35 );
									}
								?>
							</div>
						</div>
						<?php $slider_counter++; ?>
					<?php endwhile; ?>
				<?php endif; ?>
				<?php wp_reset_postdata(); ?>
			</div>
			<?php if ( $linen->use_javascript_slider() ) : ?>
				<a href="#" class="prev"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/featured-arrow-prev.png' ); ?>" width="20" height="40" alt="Arrow for previous featured post"></a>
				<a href="#" class="next"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/featured-arrow-next.png' ); ?>" width="20" height="40" alt="Arrow for next featured post"></a>
			<?php endif; ?>
		</div>
	</div>
</div><!--end featured-->